<?php
ini_set ("display_errors", "0");
require("./connect.php");
include "phpass/PasswordHash.php";

// Check user inactive or not
$querycek = "SELECT id, CASE WHEN field_5 = 0 THEN 'INACTIVE' ELSE 'OK' END cek_status, password AS USERPASSWORD FROM app_entity_1 WHERE field_12 = ? OR field_643 = ?;";

$stmtcek = mysqli_prepare($conn, $querycek);
mysqli_stmt_bind_param($stmtcek, 'ss', $_POST['userid'], $_POST['userid']);
mysqli_stmt_execute($stmtcek);
$resultcek = mysqli_stmt_get_result($stmtcek);

if (mysqli_num_rows($resultcek) > 0) {

    $rowcek = mysqli_fetch_assoc($resultcek);
    
    if ($rowcek['cek_status'] == 'INACTIVE') {
        echo json_encode(array("LOGIN"=>"INACTIVEUSER"));
    } 

    else if ($rowcek['cek_status'] == 'OK') {

        $pwdHasher = new PasswordHash(11, false);
        
        // Get user IP Address
        $ip = getenv('HTTP_CLIENT_IP')?:
        getenv('HTTP_X_FORWARDED_FOR')?:
        getenv('HTTP_X_FORWARDED')?:
        getenv('HTTP_FORWARDED_FOR')?:
        getenv('HTTP_FORWARDED')?:
        getenv('REMOTE_ADDR');

        if ($pwdHasher->CheckPassword($_POST['password'], $rowcek['USERPASSWORD'])) { // If password matched

            $stmtuserlogsuccess = mysqli_prepare($conn, "INSERT INTO app_users_login_log (users_id, username, identifier, is_success, date_added, version) VALUES (?, ?, ?, 1, UNIX_TIMESTAMP(NOW()), ?);");
            mysqli_stmt_bind_param($stmtuserlogsuccess, 'isss', $rowcek['id'], $_POST['userid'], $ip, $_POST['version']);
            mysqli_stmt_execute($stmtuserlogsuccess);

            $queryuserdata = "SELECT usr.id AS USERID, usr.field_12 AS USERNAME, grp.name AS USERTYPE, 
                lvl.field_399 AS USERROLE, usr.field_648 AS USERFUNCTION, lvl.field_398 AS POSITIONCODE, 
                lvl.field_399 AS POSITIONNAME, usr.field_627 AS COMP_ID, usr.field_628 AS SITE_ID, 
                usr.field_631 AS DEPTCODE, usr.field_630 AS DIVCODE, usr.field_632 AS GANGCODE, 
                usr.field_629 AS ESTATE, usr.field_208 AS EMPNAME, usr.field_643 AS EMPCODE, 
                usr.field_9 AS EMAILUSER, usr.password AS USERPASSWORD, usr.field_207 AS EMPID, 
                (SELECT `name` FROM app_global_lists_choices WHERE id = emp.field_312) AS EMPTYPE,
                usr.field_3380 AS PHONE, emp.field_2076 AS GRADE, 
                FROM_UNIXTIME(emp.field_313, '%d %M %Y') AS BIRTHDATE, 
                FROM_UNIXTIME(emp.field_314, '%d %M %Y') AS JOINDATE, 
                field_526 AS IDENTITYNO, field_2395 AS NPWP FROM app_entity_1 usr 
                INNER JOIN app_entity_31 emp ON usr.field_207 = emp.id
                INNER JOIN app_entity_36 lvl ON emp.field_310 = lvl.id 
                INNER JOIN app_access_groups grp ON grp.id = usr.field_6
                WHERE usr.field_12 = '".$_POST['userid']."' OR usr.field_643 = '".$_POST['userid']."';";

            $resultuserdata = mysqli_query($conn, $queryuserdata);
            $rowuserdata = mysqli_fetch_assoc($resultuserdata);

            echo json_encode(array_map('utf8_encode', array("LOGIN"=>"SUCCESS", 
                "USERID" => $rowuserdata['USERID'], 
                "USERNAME" => $rowuserdata['USERNAME'],
                "USERTYPE" => $rowuserdata['USERTYPE'], 
                "USERROLE" => $rowuserdata['USERROLE'], 
                "USERFUNCTION" => $rowuserdata['USERFUNCTION'], 
                "USERPASSWORD" => $rowuserdata['USERPASSWORD'], 
                "EMPCODE" => $rowuserdata['EMPCODE'], 
                "PHONE" => $rowuserdata['PHONE'], 
                "EMPNAME" => $rowuserdata['EMPNAME'], 
                "EMAILUSER" => $rowuserdata['EMAILUSER'], 
                "POSITIONCODE" => $rowuserdata['POSITIONCODE'], 
                "POSITIONNAME" => $rowuserdata['POSITIONNAME'], 
                "COMP_ID" => $rowuserdata['COMP_ID'], 
                "SITE_ID" => $rowuserdata['SITE_ID'], 
                "ESTATE" => $rowuserdata['ESTATE'], 
                "DIVCODE" => $rowuserdata['DIVCODE'], 
                "DEPTCODE" => $rowuserdata['DEPTCODE'], 
                "GANGCODE" => $rowuserdata['GANGCODE'],
                "ANCAKCODE" => "", 
                "SHIFTCODE" => "",
                "EMPID" => $rowuserdata['EMPID'],
                "EMPTYPE" => $rowuserdata['EMPTYPE'],
                "GRADE" => $rowuserdata['GRADE'],
                "BIRTHDATE" => $rowuserdata['BIRTHDATE'],
                "JOINDATE" => $rowuserdata['JOINDATE'],
                "NPWP" => $rowuserdata['NPWP'],
                "IDENTITYNO" => $rowuserdata['IDENTITYNO']
            )));

        } else {
            $stmtuserlogfail = mysqli_prepare($conn, "INSERT INTO app_users_login_log (users_id, username, identifier, is_success, date_added, version) VALUES (?, ?, ?, 0, UNIX_TIMESTAMP(NOW()), ?);");
            mysqli_stmt_bind_param($stmtuserlogfail, 'isss', $rowcek['id'], $_POST['userid'], $ip, $_POST['version']);
            mysqli_stmt_execute($stmtuserlogfail);

            echo json_encode(array("LOGIN"=>"WRONGPASSWORD"));
        }

    }
    
} else {
    echo json_encode(array("LOGIN"=>"NOUSER"));
}

?>