<?php
require("../connect.php");
require __DIR__ . "/dompdf/vendor/autoload.php";

use Dompdf\Dompdf;
use Dompdf\Options;

// Setting up data
// Get detail upah bulanan
$stmtUpahBulanan = mysqli_prepare($conn, "SELECT id, field_1620,
(SELECT field_264 FROM app_entity_30 WHERE field_263 = field_1610) AS COMPCODE, 
(SELECT field_309 FROM app_entity_31 WHERE id = field_1621) AS EMPNAME,  
(SELECT field_399 FROM app_entity_36 WHERE id = field_1619) AS EMPPOSITION,
(SELECT `name` FROM app_global_lists_choices WHERE id = field_1623) AS EMPFUNC, 
(SELECT `name` FROM app_global_lists_choices WHERE id = field_1617) AS EMPTYPE, 
(SELECT `name` FROM app_global_lists_choices WHERE id = field_2077) AS EMPGRADE,
CONCAT('Rp',FORMAT(field_1634, 0),',-') AS GAPOK, 
CONCAT('Rp',FORMAT(field_2044, 0),',-') AS PROPORSIGAJI,
CONCAT('Rp',FORMAT(field_1631, 0),',-') AS TUNJANGANJABATAN, 
CONCAT('Rp',FORMAT(field_1632, 0),',-') AS TUNJANGANTETAP, 
CONCAT('Rp',FORMAT(field_1633, 0),',-') AS TUNJANGANTDKTETAP, 
CONCAT('Rp',FORMAT(field_1635, 0),',-') AS TUNJANGANDLL, 
CONCAT('Rp',FORMAT(IFNULL(field_1637, 0), 0),',-') AS LEMBUR, 
CONCAT('Rp',FORMAT(field_1627, 0),',-') AS BPJSCOMP, 
CONCAT('Rp',FORMAT(field_1622, 0),',-') AS NATURA, 
CONCAT('Rp',FORMAT(field_1638, 0),',-') AS PREMIKERJA, 
CONCAT('Rp',FORMAT(field_1643, 0),',-') AS PENALTI, 
CONCAT('Rp',FORMAT(IFNULL(field_1626, 0), 0),',-') AS RAPELTHR, 
CONCAT('Rp',FORMAT(field_1629, 0),',-') AS GAJIGROSS, 
CONCAT('Rp',FORMAT(field_1636, 0),',-') AS POTONGANJABATAN, 
CONCAT('Rp',FORMAT(field_1639, 0),',-') AS JHTKARYAWAN, 
CONCAT('Rp',FORMAT(field_1642, 0),',-') AS PENSIUNKARYAWAN, 
CONCAT('Rp',FORMAT(field_1641, 0),',-') AS PPH21, 
CONCAT('Rp',FORMAT(field_1640, 0),',-') AS BPJSKARYAWAN, 
CONCAT('Rp',FORMAT(field_1685, 0),',-') AS TOTALTAX, 
CONCAT('Rp',FORMAT(IFNULL(field_1646, 0), 0),',-') AS IURANKOPERASI, 
CONCAT('Rp',FORMAT(IFNULL(field_1645, 0), 0),',-') AS IURANSPM, 
CONCAT('Rp',FORMAT(IFNULL(field_1647, 0), 0),',-') AS POTONGANPINJAMAN, 
CONCAT('Rp',FORMAT(IFNULL(field_1686, 0), 0),',-') AS POTONGANPRIBADI, 
CONCAT('Rp',FORMAT(IFNULL(field_1615, 0), 0),',-') AS GAJIBERSIH 
FROM app_entity_82 WHERE parent_item_id = ? AND field_1614 = ?;");
mysqli_stmt_bind_param($stmtUpahBulanan, 'is', $_GET['empid'], $_GET['periode']);
mysqli_stmt_execute($stmtUpahBulanan);
$resultBulananUpah = mysqli_stmt_get_result($stmtUpahBulanan);
$rowBulanan = mysqli_fetch_assoc($resultBulananUpah);

/**
 * Set the Dompdf options
 */
$options = new Options;
$options->setChroot(__DIR__);
$options->setIsRemoteEnabled(true);

$dompdf = new Dompdf($options);

/**
 * Set the paper size and orientation
 */
$dompdf->setPaper("A4", "landscape");

/**
 * Load the HTML and replace placeholders with values from the form
 */
$html = file_get_contents("template_pdf.html");

//Setting value basic info
$html = str_replace(["{#1610:Company}", "{#1614:Periode Gaji}", "{#1620:NIK Karyawan}", 
"{#1621:Nama Karyawan}", "{#1619:Posisi Jabatan}", "{#1623:Fungsi Jabatan}", 
"{#1617:Type Karyawan}", "{#2077:Golongan}"], 
[$rowBulanan['COMPCODE'], $_GET['periode'], $rowBulanan['field_1620'], 
$rowBulanan['EMPNAME'], $rowBulanan['EMPPOSITION'], substr($rowBulanan['EMPFUNC'], strpos($rowBulanan['EMPFUNC'], "- ")+2), 
$rowBulanan['EMPTYPE'], $rowBulanan['EMPGRADE']], $html);

// Setting value Pendatapan
$html = str_replace(["{#1634:Gaji Pokok}", "{#2044:Proporsi Gaji}", "{#1631:Tunj Jabatan}", 
"{#1632:Tunj Tetap}", "{#1633:Tunj Tdk Tetap}", "{#1635:Tunj Lain-lain}", "{#1637:Lembur}", 
"{#1627:BPJS ditanggung Perusahaan}", "{#1622:Tunj Natura}", "{#1638:Premi Pekerjaan}", 
"{#1643:Penalti Premi}", "{#1626:Rapel atau THR}", "{#1629:GROSS}"], 
[$rowBulanan['GAPOK'], $rowBulanan['PROPORSIGAJI'],$rowBulanan['TUNJANGANJABATAN'], $rowBulanan['TUNJANGANTETAP'], 
$rowBulanan['TUNJANGANTDKTETAP'], $rowBulanan['TUNJANGANDLL'], $rowBulanan['LEMBUR'], 
$rowBulanan['BPJSCOMP'], $rowBulanan['NATURA'], $rowBulanan['PREMIKERJA'], 
$rowBulanan['PENALTI'], $rowBulanan['RAPELTHR'], $rowBulanan['GAJIGROSS']], $html);

//Setting value Deduction info
$html = str_replace(["{#1636:Biaya Jabatan}", "{#1639:JHT}", 
"{#1642:Jaminan Pensiun}", "{#1685:Pengurang Pajak}", "{#1641:Potongan PPh21}", 
"{#1640:BPJS ditanggung Karyawan}", "{#1646:Iuran Koperasi}", "{#1645:Iuran SPM}", 
"{#1647:Potongan Pinjaman}", "{#1686:Potongan Pribadi}", "{#1615:Upah Bersih}"], 
[$rowBulanan['POTONGANJABATAN'], $rowBulanan['JHTKARYAWAN'], 
$rowBulanan['PENSIUNKARYAWAN'], $rowBulanan['TOTALTAX'], $rowBulanan['PPH21'], 
$rowBulanan['BPJSKARYAWAN'], $rowBulanan['IURANKOPERASI'], $rowBulanan['IURANSPM'], 
$rowBulanan['POTONGANPINJAMAN'], $rowBulanan['POTONGANPRIBADI'], $rowBulanan['GAJIBERSIH']], $html);

$dompdf->loadHtml($html);
//$dompdf->loadHtmlFile("template.html");

/**
 * Create the PDF and set attributes
 */
$dompdf->render();

$dompdf->addInfo("Title", "An Example PDF"); // "add_info" in earlier versions of Dompdf

/**
 * Send the PDF to the browser
 */
$dompdf->stream("invoice.pdf", ["Attachment" => 0]);

/**
 * Save the PDF file locally
 */
// $output = $dompdf->output();
// file_put_contents("file.pdf", $output);
?>